; WALK.ASM 
;
; To use this program connect four LEDs from each of RB0-RB3 to ground 
; via four 470 ohm resistors.  The LEDs are illuminated one at time in 
; a to-and-fro pattern.
;
; The illumination rate is more or less independent of the PIC clock
; frequency and configuration although this program assumes a crystal
; oscillator.  The program includes the __CONFIG, __IDLOCS and DE
; directives (mostly just to show how they can be used).  You can  
; download and execute this program using "TOPIC -G WALK.HEX".  If your
; setup doesn't use a crystal oscillator you'll need to change the 
; argument to the __CONFIG directive and re-assemble or simply set the 
; correct config on the command line.  For example to use an RC 
; oscillator run "TOPIC -RWG WALK.HEX".
;

        LIST            P=16C84
        ERRORLEVEL      -302    ;SUPPRESS BANK SELECTION MESSAGES
        __CONFIG        3FF5H   ;XT OSC, WATCHDOG
        __IDLOCS        1234    ;DUMMY ID WORDS
;    
PORTB   EQU     6 
TRISB   EQU     86H
OPTREG  EQU     81H
STATUS  EQU     3
CARRY   EQU     0
RP0     EQU     5
MSB     EQU     3               ;BIT POSITION OF LEFTMOST LED
;
        CLRF    PORTB           ;ALL LEDS OFF
        BSF     STATUS,RP0      ;SELECT REGISTER BANK 1   
        CLRF    TRISB           ;SET PORTB TO ALL OUTPUTS
        MOVLW   0AH
        MOVWF   OPTREG          ;ASSIGN PRESCALER (1:4) TO WDT
        BCF     STATUS,RP0      ;SELECT REGISTER BANK 0
        INCF    PORTB,F         ;TURN ON RIGHTMOST LED
        BCF     STATUS,CARRY    ;CLEAR CARRY
LEFT    SLEEP                   ;WAIT FOR WDT TIMEOUT
        RLF     PORTB,F         ;TURN ON LED TO LEFT
        BTFSS   PORTB,MSB       ;REACHED LEFTMOST?
        GOTO    LEFT            ;LOOP IF NOT
RIGHT   SLEEP                   ;WAIT FOR WDT TIMEOUT
        RRF     PORTB,F         ;TURN ON LED TO RIGHT
        BTFSS   PORTB,0         ;REACHED RIGHTMOST?
        GOTO    RIGHT           ;LOOP IF NOT
        GOTO    LEFT            ;START NEW CYCLE
;
        ORG     2100H           ;SOME DUMMY EEDATA
;
        DE      "Copyright (C) 1996 David Tait"
        END

